RequireScript("json2.js");
RequireScript("logger.js");
RequireScript("longestRoad.js");

function game() {
	var Server = new _server();
	Server.start();
}

function _server() {
	this.font = LoadFont("frank.rfn");
	this.inputText = "";
	this.debug = false;
	this.ticker = 0;
	this.mouse = LoadImage("mouse.png");
	this.hexImage = [LoadImage("newTiles/nTileBrick.png"), LoadImage("newTiles/nTileOre.png"), LoadImage("newTiles/nTileSheep.png"), //0-2
		LoadImage("newTiles/nTileWheat.png"), LoadImage("newTiles/nTileWood.png"), LoadImage("newTiles/nTileDesert.png"),//3-5
		LoadImage("newTiles/nTileWater.png"), LoadImage("newTiles/nTileAll.png"), LoadImage("newTiles/nTileGreen.png"), //6-8
		LoadImage("newTiles/nTileRed.png"), LoadImage("newTiles/nTileIndicator.png"), LoadImage("newTiles/nTilePort.png"),//9-11
		LoadImage("newTiles/nTileGold.png")];
	this.hexPort = [LoadImage("portBrick.png"), LoadImage("portOre.png"), LoadImage("portSheep.png"), LoadImage("portWheat.png"),
		LoadImage("portWood.png"), LoadImage("portThree.png")];
	this.color = [CreateColor(0,0,0),CreateColor(255,255,255),CreateColor(255,0,0),CreateColor(241,234,141)];
	this.phase = "waitforplayers";
	this.wait = false;
	this.port = ListenOnPort(1123);
	this.players = [];
	this.playerLimit = 3;
	this.turn = getRandom(0, 2);
	this.order = getOrder(this.turn);
	this.dice = [false, 0, 0];
	//this.die = [LoadImage("dice1.png"),LoadImage("dice2.png"),LoadImage("dice3.png"),LoadImage("dice4.png"),LoadImage("dice5.png"),LoadImage("dice6.png")];
	this.started = false;
	this.options = { goldMine: false, boats: false, noRobOn2: false, vpToWin: 9 };
	this.robber = { where: [-1,-1], image: LoadImage("robber.png") };
	this.largestArmy = [-1, 0]; //who holds and how many.
	this.longestRoad = [-1, 0];
	this.hex; this.corners; this.roads; this.d_cards;
	this.numbers;
	this.initialize();
	this.mapList = GetFileList("save/maps/"); for (var i = 0; i < this.mapList.length; i++) { this.mapList[i] = this.mapList[i].substring(0, this.mapList[i].length - 4); }
	this.loadMap(this.mapList[0]);
}

_server.prototype.start = function() {
	this.log = new _logger(700,5, this.font, this.color[1]);
	this.log.logThis("Address", 'GetLocalAddress()');
	this.log.logThis("turn",this.turn);
	while (!IsKeyPressed(KEY_F4)) {
		this.draw();
		this.input();
		this.handler();
		this.log.show();
		this.ticker++;
		FlipScreen();
	}
}

_server.prototype.draw = function() {
	this.font.drawText(20, 620, this.inputText);
	for (var i = 0; i < this.hex.length; i++) {
		if (this.hexImage[this.hex[i].image] == undefined) { Abort(i + ": "  + this.hex[i].image) }
		this.hexImage[this.hex[i].image].blit(this.hex[i].x, this.hex[i].y);
		if (this.hex[i].number != -1) {
			var offset = 0;
			if (this.hex[i].number > 9) { offset = -3; }
			if (this.hex[i].number == 6 || this.hex[i].number == 8) { this.font.setColorMask(this.color[2]); }
			else { this.font.setColorMask(this.color[0]); }
			FilledCircle(this.hex[i].x + 34, this.hex[i].y + 40, 11, this.color[3], true);
			this.font.drawText(this.hex[i].x + offset + 30, this.hex[i].y + 32, this.hex[i].number);
		}
	}
	for (var i = 0; i < this.ports.length; i++) {
		Line(this.corners[this.ports[i][1]].x-1, this.corners[this.ports[i][1]].y, this.hex[this.ports[i][0]].x + 34, this.hex[this.ports[i][0]].y + 40, this.color[1]);
		Line(this.corners[this.ports[i][2]].x-1, this.corners[this.ports[i][2]].y, this.hex[this.ports[i][0]].x + 34, this.hex[this.ports[i][0]].y + 40, this.color[1]);
		this.hexPort[this.hex[this.ports[i][0]].port].blit(this.hex[this.ports[i][0]].x + 26, this.hex[this.ports[i][0]].y + 30);
	}
	var x = GetMouseX(); var y = GetMouseY();
	this.mouse.blit(x, y);
}

_server.prototype.input = function() {
	var x = GetMouseX();
	var y = GetMouseY();
	
	switch(this.phase) {
		case "waitforplayers": { //wait for connections to server
			if (this.port.isConnected() && this.players.length < this.playerLimit) {
				this.players.push(new _client());
				this.players[this.players.length-1].port = this.port;
				this.players[this.players.length-1].id = this.players.length - 1;
				this.players[this.players.length-1].send("id*" + this.players[this.players.length - 1].id + "\n");
				for (var i = 0; i < this.players.length; i++) {
					this.send("name*" + this.players[i].id + "*" + this.players[i].name + "\n");
					this.send("gameOver*" + i + "*" + this.players[i].careerPoints + "*" + this.players[i].wins + "*" + this.players[i].losses + "\n");
					if (this.players[i].currentColor != undefined) { this.send("color*" + i + "*" + this.players[i].currentColor + "\n"); }
				}
				this.send("optionVP*" + this.options.vpToWin + "\n");
				if (this.options.goldMine) { this.send("optionGoldMine*yes\n"); }
				else { this.send("optionGoldMine*no\n"); }
				if (this.options.boats) { this.send("optionBoats*yes\n"); }
				else { this.send("optionBoats*no\n"); }
				if (this.options.noRobOn2) { this.send("noRobOn2*yes\n"); }
				else { this.send("noRobOn2*no\n"); }
				this.sendBoard(this.players[this.players.length-1].id);
				this.players[this.players.length-1].send("mapList*" + this.mapList + "\n");
				this.port = ListenOnPort(1123);
			}
			else if (this.players.length == this.playerLimit) { this.wait = true; this.phase = "preGame"; }
			break;
		}
		case "preGame": { //send map details.
			if (!this.wait) {
				this.setHexes();
				this.setNumbers();
				var num = [];
				var image = [];
				for (var i = 0; i < this.hex.length; i++) {
					num.push(this.hex[i].number); image.push(this.hex[i].image);
				}
				this.send("board*" + image + "\n");
				this.send("number*" + num + "\n");
				this.send("robbers*" + this.robber.where[0] + "*" + this.robber.where[1] + "\n");
				this.send("turn*" + this.turn + "\n");
				this.phase = "starting";
				this.wait = true;
			}
			break;
		}
		case "starting": { //place beginning settlements
			if (!this.wait) {
				this.order.shift();
				if (this.order.length > 0) {
					this.turn = this.order[0];
					this.send("turn*" + this.turn + "\n");
				}
				else  { 
					this.started = true;
					this.send("started\n"); 
					this.phase = "play";
				}
				this.wait = true;
			}
			break;
		}
		case "play": {
			if (!this.wait) {
				if (this.turn == 2) { this.turn = 0; }
				else { this.turn++; }
				this.send("turn*" + this.turn + "\n"); 
				this.wait = true;
			}
			break;
		}
		case "discard": {
			if (this.players[0].discard == 0 && this.players[1].discard == 0 && this.players[2].discard == 0) {
				this.send("discarded*" + this.players[0].discarded + "*" + this.players[1].discarded + "*" + this.players[2].discarded + "\n");
				if (this.playerAbleToRob(this.turn)) { this.send("placeRobber\n"); }
				else { this.send("go\n"); }
				this.phase = "play";
			}
			break;
		}
	}
	if (this.debug) {
		while(AreKeysLeft()) {
			var key = GetKey();
			switch(key) {
				case KEY_BACKSPACE: {
					if (this.inputText != "") { this.inputText = this.inputText.substring(0, this.inputText.length - 1); }
					break;
				}
				case KEY_ENTER: {
					if (this.inputText != "") {
						if (this.debug) {
							this.log.logThis("Debug: " + this.inputText, eval(this.inputText));
							this.inputText = "";
							this.debug = false;
						}
					}
				}
				case KEY_ESCAPE: {
					if (this.debug) { this.debug = false; }
					break;
				}
				default: { this.inputText += GetKeyString(key,IsKeyPressed(KEY_SHIFT)); }
			}
		}
	}
	else {
		while(AreKeysLeft()) {
			var key = GetKey();
			switch(key) {
				case KEY_TILDE: {
					this.debug = true;
					break;
				}
			}
		}
	}
}

_server.prototype.handler = function() {
	for (var i = 0; i < this.players.length; i++) {
		if (this.players[i].port.getPendingReadSize() > 0) {
			var fullRead = CreateStringFromByteArray(this.players[i].port.read(this.players[i].port.getPendingReadSize())); //get all pending information
			var seperatedInfo = fullRead.split("\n"); //seperate information in blocks
			while(seperatedInfo.length > 0) { //while there is information to get
				var keyword = seperatedInfo[0].split("*"); //deletes dividers
				switch (keyword[0]) { //what information are we handling
					case "ping": {
						this.players[i].latency = GetTime() - this.players[i].ping;
						this.send("latency*" + i + "*" + this.players[i].latency + "\n");
						break;
					}
					case "start": {
						this.wait = false;
						break;
					}
					case "map": {
						this.ports = [];
						this.loadMap(keyword[1]);
						for (var j = 0; j < this.players.length; j++) { this.sendBoard(j); }						
						this.send("map*" + keyword[2] + "\n");
						break;
					}
					case "vpToWin": {
						this.options.vpToWin = keyword[1];
						this.send("optionVP*" + keyword[1] + "\n");
						break;
					}
					case "addGoldMine": {
						if (keyword[1] == "no") { this.options.goldMine = false; }
						else { this.options.goldMine = true; }
						this.send("optionGoldMine*" + keyword[1] + "\n");
						break;
					}
					case "optBoats": {
						if (keyword[1] == "yes") { this.options.boats = true; }
						else { this.options.boats = false; }
						this.send("optionBoats*" + keyword[1] + "\n");
						break;
					}
					case "noRob2": {
						if (keyword[1] == "no") { this.options.noRobOn2 = false; }
						else { this.options.noRobOn2 = true; }
						this.send("noRobOn2*" + keyword[1] + "\n");
						break;
					}
					case "color": {
						this.send("color*" + i + "*" + keyword[1] + "\n");
						this.players[i].currentColor = keyword[1]; 
						break;
					}
					case "login": { 
						var file = OpenFile("players/" + keyword[1] + ".txt");
						if (file.read("pass","nil") == keyword[2] && !this.checkDuplicatePlayer(keyword[1])) {
						this.players[i].name = keyword[1];
						this.players[i].careerPoints = file.read("careerPts",0);
						this.players[i].wins = file.read("wins", 0);
						this.players[i].losses = file.read("losses", 0);
						this.send("name*"+i+"*"+this.players[i].name+"\n" + "gameOver*" + i + "*" + this.players[i].careerPoints + "*" + this.players[i].wins + "*" + this.players[i].losses + "\n");
						this.players[i].send("connected*" + i + "\n");
						}
						else if (this.checkDuplicatePlayer(keyword[1])) { this.players[i].send("nameExists\n"); }
						else if (file.read("pass","nil") == "nil") {
							this.players[i].name = keyword[1];
							this.players[i].careerPoints = file.read("careerPts",0);
							this.players[i].wins = file.read("wins", 0);
							this.players[i].losses = file.read("losses", 0);
							file.write("pass",keyword[2]);
							this.send("name*"+i+"*"+this.players[i].name+"\n" + "gameOver*" + i + "*" + this.players[i].careerPoints + "*" + this.players[i].wins + "*" + this.players[i].losses + "\n");
							this.players[i].send("connected*" + i + "\n");				
						}
						else { this.players[i].send("noPass\n"); }
						file.close();
						break;
					}
					case "tradeResponse": {
						this.send("tradeResponse*" + i + "*don\'t have\n");
						break;
					}
					case "leaveTrade": {
						this.send("tradeResponse*" + i + "*" + "not interested\n");
						this.send("leftTrade*" + i + "\n");
						break;
					}
					case "yop": {
						this.players[i].resources.push(keyword[1], keyword[2]);
						this.players[i].resources.sort(compareNumbers);
						this.send("yop*" + i + "*" + keyword[1] + "*" + keyword[2] + "\n" + "resources*" + i + "*" + this.players[i].resources + "\n");
						break;
					}
					case "monopoly": {
						var cards = [];
						var from = [];
						var amount = 0;
						for (var j = 0; j < this.players.length; j++) {
							if (j != i) {
								cards.push(this.howManyResource(keyword[1], j)); //what, who
								amount += this.howManyResource(keyword[1],j);
								from.push(j);
							}
						}
						this.removeResource(keyword[1], cards[0], from[0]); //what, amount, who
						this.removeResource(keyword[1], cards[1], from[1]);

						for (var j = 0; j < cards[0]; j++) { this.players[i].resources.push(keyword[1]); }
						for (var j = 0; j < cards[1]; j++) { this.players[i].resources.push(keyword[1]); }
						var tail = "";
						for (var j = 0 ; j < this.players.length; j++) {
							tail += "resources*" + j + "*" + this.players[j].resources + "\n";
						}
						for (var j = 0; j < this.players.length; j++) { this.players[j].resources.sort(compareNumbers); }
						this.send("monopoly*" + i + "*" + amount + "*" + keyword[1] + "\n" + tail);
						break;
					}
					case "trade": {
						//1 from 2 give, 3 get a - who
						var remove = JSON.parse("\[" + keyword[2] + "\]");
						for (var j = 0; j < remove.length; j++) { this.removeResource(remove[j],1,i); }
						var add = JSON.parse("\[" + keyword[3] + "\]");
						for (var j = 0; j < add.length; j++) { this.players[i].resources.push(add[j]); }
						var tail = "";
						if (keyword[1] != 9) {
							for (var j = 0; j < remove.length; j++) { this.players[keyword[1]].resources.push(remove[j]); }
							for (var j = 0; j < add.length; j++) { 		this.removeResource(add[j], 1, keyword[1]); }
						}
						for (var j = 0; j < this.players.length; j++) { this.players[j].resources.sort(compareNumbers); tail += "resources*" + j + "*" + this.players[j].resources + "\n"; }
						this.send("trade*" + i + "*" + remove+ "*" + keyword[1] + "*" + add + "\n" + tail);
						break;
					}
					case "leftTrade": {
						this.send("leftTrade*"+i+"\n");
						break;
					}
					case "propose": {
						this.send("propose*" + i + "*" + keyword[1] + "*" + keyword[2] + "\n");
						break;
					}
					case "city": {
						this.players[i].cities.push(this.players[i].settlements[keyword[1]]);
						this.players[i].settlements.splice(keyword[1], 1);
						this.removeResource(1,3,i); this.removeResource(3,2,i);
						this.players[i].points++;
						this.players[i].resources.sort(compareNumbers); 
						this.send("points*" + i + "*" + this.players[i].points + "\n" + "city*" + i + "*" + keyword[1] + "\n" + "resources*" + i + "*" + this.players[i].resources + "\n");
						break;
					}
					case "buydCard": {
						var card = this.d_cards.pop();
						this.players[i].d_cards.push(card);
						this.players[i].d_cards.sort(compareNumbers);
						this.removeResource(1,1,i);
						this.removeResource(2,1,i);
						this.removeResource(3,1,i);
						this.players[i].resources.sort(compareNumbers); 
						this.send("dCards*" + i + "*" + this.players[i].d_cards + "\n" + "boughtDcard*" + i + "*" + card + "\n" + "resources*" + i + "*" + this.players[i].resources + "\n");
						break;
					}
					case "playd_card": {
						//d_cards 1, used 2
						this.players[i].tableCards.push(keyword[2]);
						this.players[i].d_cards.splice(keyword[1], 1);
						var point = ""
						if (keyword[2] > 3) { // victory point
							this.players[i].points++;
							point = "points*" + i + "*" + this.players[i].points + "\n";
						}
						if (keyword[2] == 1) { this.roadsBuilt = 0; }
						this.players[i].d_cards.sort(compareNumbers); 
						this.send("playd_card*" + i + "*" + keyword[2] + "\n" + "dCards*" + i + "*" + this.players[i].d_cards + "\n" + point);
						break;
					}
					case "doneTurn": { //configure winning stats here.
						if (this.players[i].points >= this.options.vpToWin) {
							this.send("winner\n");
							this.phase = "winner"; 
							for (var j = 0; j < this.players.length; j++) {
								var file = OpenFile("players/"+this.players[j].name + ".txt");
								var careerPts = this.players[j].careerPoints;
								careerPts += this.players[j].points;
								file.write("careerPts", careerPts);
								var win = this.players[j].wins;
								var loss = this.players[j].losses;
								if (j == i) { //winner
									win += 1;
									file.write("wins", win);
								}
								else { // loser...
									loss += 1;
									file.write("loss",loss);
								}
								this.send("gameOver*" + j + "*" + careerPts + "*" + win + "*" + loss + "\n");
							}
						}
						else { this.wait = false; }
						break;
					}
					case "soldier": {
						this.players[i].tableCards.push(0);
						this.players[i].d_cards.shift();
						var army = 0;
						for (var j = 0; j < this.players[i].tableCards.length; j++) {
							if (this.players[i].tableCards[j] == 0) { army += 1; }
						}
						var text = "";
						if (army > 2 && army > this.largestArmy[1]) {
							if (this.largestArmy[0] == -1) { this.players[i].points += 2; }
							else if (this.largestArmy[0] != i) {
								this.players[i].points += 2;
								this.players[this.largestArmy[0]].points -= 2;
								var text = "points*" + this.largestArmy[0] + "*" + this.players[this.largestArmy[0]].points + "\n";
							}
							this.largestArmy = [i, army];
							this.send("points*" + i + "*" + this.players[i].points + "\n" + "largestArmy*" + this.largestArmy[0] + "\n" + text);
						}
						this.log.logThis("army",i + ", " + army);
						this.log.logThis("largestArmy",this.largestArmy);
						this.send("dCards*" + i + "*" + this.players[i].d_cards + "\n" + "playd_card*" + i + "*" + 0 + "\n");
						break;
					}
					case "choseRobber": {
						this.send("choseRobber*" + i + "\n");
						break;
					}
					case "robbed": {
						//a stealing from 1
						var p = keyword[1];
						if (this.players[p].resources.length > 0) {
							var card = getRandom(0, (this.players[p].resources.length - 1));
							card = this.players[p].resources.splice(card, 1);
							this.players[i].resources.push(card);
							this.players[i].resources.sort(compareNumbers); 
							this.players[p].resources.sort(compareNumbers); 
							this.send("rob*" + i + "*" + p + "*" + card + "\n" + "resources*" + i + "*" + this.players[i].resources + "\n" + "resources*" + p + "*" + this.players[p].resources + "\n");
						}
						break;
					}
					case "robber": {
						//1 = robber,  2 = new location
						this.hex[this.robber.where[keyword[1]]].robber = false;
						this.robber.where[keyword[1]] = keyword[2];
						this.hex[keyword[2]].robber = true;
						this.send("robber*" + i + "*" + keyword[1] + "*" + keyword[2] + "\n");
						
						var places = [];
						for (var a = 0; a < this.corners.length; a++) {
							for (var j = 0; j < this.corners[a].tiles.length; j++) {
								if (this.corners[a].tiles[j].x == this.hex[keyword[2]].x && this.corners[a].tiles[j].y == this.hex[keyword[2]].y) {
									if (this.corners[a].occupied != i && this.corners[a].occupied != -1 && this.corners[a].occupied != 9) { 
										var duplicate = false;
										for (var u = 0; u < places.length; u++) {
											if (places[u] == this.corners[a].occupied) { duplicate = true; }
										}
										if (!duplicate) { places.push(this.corners[a].occupied); }
									}
								}
							}
						}
						if (places.length > 0) {
							if (places.length > 1) { //more than 1 person to rob
								if (this.players[places[0]].resources.length == 0 && this.players[places[1]].resources.length == 0) { //nothing to rob
									this.send("noRob*" + i + "\n");
								}
								else { //pick who to rob
									this.send("pickWhoToRob*" + i + "*" + places[0] + "*" + places[1] + "\n");
								}
							}
							else { //only 1 to rob...
								var p = places[0];
								if (this.players[p].resources.length > 0) {
									var card = getRandom(0, (this.players[p].resources.length - 1));
									card = this.players[p].resources.splice(card, 1);
									this.players[i].resources.push(card);
									this.players[i].resources.sort(compareNumbers);
									this.players[p].resources.sort(compareNumbers);
									this.send("rob*" + i + "*" + p + "*" + card + "\n" + "resources*" + i + "*" + this.players[i].resources + "\n" + "resources*" + p + "*" + this.players[p].resources + "\n");
								}
								else { this.send("noRob*" + i + "\n"); }
							}
						}
						else { this.send("noRob*" + i + "\n"); }
						break;
					}
					case "inTrade": {
						this.send("inTrade\n");
						break;
					}
					case "discard": {
						var cards = JSON.parse("\[" + keyword[1] + "\]");
						var types = [0,0,0,0,0];
						for (var j = 0; j < cards.length; j++) {
							types[eval(cards[j])]++;
						}
						if (types[0] > 0) { this.removeResource(0, types[0], i); }
						if (types[1] > 0) { this.removeResource(1, types[1], i); }
						if (types[2] > 0) { this.removeResource(2, types[2], i); }
						if (types[3] > 0) { this.removeResource(3, types[3], i); }
						if (types[4] > 0) { this.removeResource(4, types[4], i); }
						this.players[i].discard = 0;
						this.players[i].discarded = keyword[1];
						this.players[i].resources.sort(compareNumbers); 
						this.send("resources*" + i + "*" + this.players[i].resources + "\n" + "noteDiscard*" + i + "\n");
						break;
					}
					case "roll": {
						this.dice[1] = this.getDie();
						this.dice[2] = this.getDie();
						var roll = this.dice[1] + this.dice[2] + 2;
						this.send("roll*" + this.dice[1] + "*" + this.dice[2] + "*" + roll +  "\n");
						this.dice[0] = false;
						
						if (roll != 7) {
							this.distributeResources(roll);
							this.send("afterRoll\n");
						}
						else { // rolled a 7
							var discard = [0,0,0];
							for (var j = 0; j < this.players.length; j++) {
								this.players[j].discarded = [];
								if (this.players[j].resources.length > 7) { 
									discard[j] = Math.floor(this.players[j].resources.length / 2);
									this.players[j].discard = discard[j];
								}
								else { this.players[j].discarded = "nil"; }
							}
							if (this.players[0].discard > 0 || this.players[1].discard > 0 || this.players[2].discard > 0) {
								this.send("discard*" + discard + "\n");
								this.phase = "discard";
							}
							else { 
								if (this.options.noRobOn2) {
									if (this.players[0].points > 2 || this.players[1].points > 2 || this.players[2].points > 2) {
										this.send("placeRobber*"+i+"\n"); 
									}
									else { this.send("go\n"); }
								}
								else { this.send("placeRobber*" + i + "\n"); }
							}
						}
						break;
					}
					case "dRoad": {
						this.players[i].roads.push(keyword[1]);
						this.roads[keyword[1]][2] = i;
						if (i != this.longestRoad[0]) { 
							var roads = [];
							var hadLongest = this.longestRoad[0];
							for (var j = 0; j < this.players[i].roads.length; j++) { roads.push(this.players[i].roads[j]); }
							if (this.checkLongestRoad(i, roads)) {
								if (this.longestRoad[0] != -1) { 
									this.players[this.longestRoad[0]].points -= 2;
									this.send("points*" + this.longestRoad[0] + "*" + this.players[this.longestRoad[0]].points + "\n");
								}
								this.players[i].points += 2;
								this.send("points*" + i + "*" + this.players[i].points + "\n");
								this.longestRoad[0] = i;
								if (hadLongest != this.longestRoad[0]) { this.send("longestRoad*" + i + "*" + keyword[1] + "\n"); }
							} 
						}
						this.send("road*" + i + "*" + keyword[1] + "\n");
						this.roadsBuilt += 1;
						if (this.roadsBuilt == 2)  { this.send("stopRoadBuild\n"); }
						break;
					}
					case "road": {
						this.players[i].roads.push(keyword[1]);
						this.roads[keyword[1]][2] = i;
						if (this.started) {
							var hadLongest = this.longestRoad[0];
							if (i != this.longestRoad[0]) { 
								var roads = [];
								for (var j = 0; j < this.players[i].roads.length; j++) { roads.push(this.players[i].roads[j]); }
								if (this.checkLongestRoad(i, roads)) {
									if (this.longestRoad[0] != -1) { 
										this.players[this.longestRoad[0]].points -= 2;
										this.send("points*" + this.longestRoad[0] + "*" + this.players[this.longestRoad[0]].points + "\n");
									}
									this.players[i].points += 2;
									this.send("points*" + i + "*" + this.players[i].points + "\n");
									this.longestRoad[0] = i;
									if (hadLongest != this.longestRoad[0]) { this.send("longestRoad*" + i + "*" + keyword[1] + "\n"); }
								} 
							}
							this.removeResource(0, 1, i); this.removeResource(4, 1, i);
						}
						else { this.wait = false; }
						this.send("road*" + i + "*" + keyword[1] + "\n" + "resources*" + i + "*" + this.players[i].resources + "\n");
						break;
					}
					case "boat": {
						this.players[i].roads.push(keyword[1]);
						this.players[i].boats++;
						this.roads[keyword[1]][2] = i;
						this.roads[keyword[1]][3] = true;
						if (i != this.longestRoad[0]) { 
							var roads = [];
							for (var j = 0; j < this.players[i].roads.length; j++) { roads.push(this.players[i].roads[j]); }
							if (this.checkLongestRoad(i, roads)) {
								if (this.longestRoad[0] != -1) { 
									this.players[this.longestRoad[0]].points -= 2;
									this.send("points*" + this.longestRoad[0] + "*" + this.players[this.longestRoad[0]].points + "\n");
								}
								this.players[i].points += 2;
								this.send("points*" + i + "*" + this.players[i].points + "\n");
								this.longestRoad[0] = i;
								this.send("longestRoad*" + i + "*" + keyword[1] + "\n");
							} 
						}
						this.removeResource(2, 1, i); this.removeResource(4, 1, i);
						this.send("boat*" + i + "*" + keyword[1] + "\n" + "resources*" + i + "*" + this.players[i].resources + "\n");
						break;
					}
					case "settlement": {
						this.players[i].settlements.push(keyword[1]);
						this.corners[keyword[1]].occupied = i
						if (this.players[i].settlements.length > 1 && !this.started) {
							this.distributeResources(keyword[1],i);
						}
						else if (this.started) {
							this.removeResource(0,1,i); this.removeResource(2,1,i); 
							this.removeResource(3,1,i); this.removeResource(4,1,i); 
						}
						this.players[i].points++;
						for (var j = 0; j < this.ports.length; j++) {
							if (this.ports[j][1] == keyword[1] || this.ports[j][2] == keyword[1]) {
								this.players[i].havePorts.push(this.ports[j][3]);
								this.players[i].havePorts.sort(compareNumbers);
							}
						}
						if (!this.started) { this.send("updateHelpSettlement*"+i+"\n"); }
						if (this.players[i].havePorts.length > 0) { var have = "havePorts*" + i + "*" + this.players[i].havePorts + "\n"; }
						else { var have = ""; }
						this.send(have + "points*" + i + "*" + this.players[i].points + "\n" + "settlement*" + i + "*" + keyword[1] + "\n" + "resources*" + i + "*" + this.players[i].resources + "\n"+"placeRoad*\n");
						break;
					}
					case "chat": {
						this.send("chat*"+ i +"*"+this.players[i].name + "*" +keyword[1] + "\n");
						break;
					}
					case "done": {
						this.players[i].wait = false;
						break;
					}
					case "name": {
						this.players[i].name = keyword[1];
						this.players[i].send("id*" + i + "\n");
						break;
					}
					default: {
						if (keyword[0] != "") { Abort(keyword[0]); }
					}
				}
				seperatedInfo = seperatedInfo.slice(1, seperatedInfo.length);
			}
		}
		if (this.ticker % 8 == 0) { this.players[i].send("ping\n"); this.players[i].ping = GetTime(); }
	}
}

_server.prototype.loadMap = function(MAP) {
	var file = OpenFile("maps/"+MAP + ".txt");
	for (var i = 0; i < this.hex.length; i++) {
		this.hex[i].image = file.read(i, 6);
	}
	var portsLength = file.read("ports", 0);
	for (var i = 0; i < portsLength; i++) {
		var pusher = [];
		for (var j = 0; j < 4; j++) {
			var a = parseInt(file.read("port"+i+","+j, "0"));
			pusher.push(a);
		}
		this.ports.push(pusher);
		this.hex[pusher[0]].port = pusher[3];
	}
	var cornersLength = file.read("corners",0);
	for (var i = 0; i < cornersLength; i++) {
		this.corners[i].occupied = file.read("cor"+i, 9);
	}
	file.flush();
	file.close();
}

_server.prototype.initialize = function() {
	this.hex = [];
	for (var i = 0; i < 86; i++) {
		this.hex[i] = { x: 0, y: 0, image: 6, robber: false, showNumber: true, number: -1, port: -1, id: i, corners: [] };
	}
	var times = 0;
	for (var i = 0; i < 10; i++) {
		for(var j = 0; j < 9; j++) {
			if (times == 87) { break; }
			if ((j % 2) == 1 && j != 0) { var p = 35; }
			else { var p = 0; }
			var print = false;
			if ((j%2)== 1){ //rows that are offseted to the right.
				if (i < 9) {	
					if (this.hex[times] == undefined) Abort(i + " " + j + " " + times);		
					this.hex[times].x = 10 + p + (i*69);
					this.hex[times].y = 10 + (j*59);
					print = true;
					;
				}
			}
			else {
				if (this.hex[times] == undefined) Abort(i + " " + j + " " + times);
				this.hex[times].x = 10 + p + (i*69);
				this.hex[times].y = 10 + (j * 59);
				print = true;
			}
			if (print) times+= 1;
		}
	}
	this.corners = [];
	for (var i = 0; i < this.hex.length; i++) { 
		this.corners.push({
				x: this.hex[i].x + 35, y: this.hex[i].y, occupied: -1, tiles: [], port: -1, });
		this.corners.push({
				x: this.hex[i].x + 1, y: this.hex[i].y+20, occupied: -1, tiles: [], port: -1, });
		this.corners.push({
				x: this.hex[i].x + 1, y: this.hex[i].y+58, occupied: -1, tiles: [], port: -1, });
	}
	for (var i = 81; i < 86; i++) {
		this.corners.push( {
			x:  this.hex[i].x + 68, y: this.hex[i].y + 20, occupied: -1, tiles: [], port: -1, });
		this.corners.push({ 
			x: this.hex[i].x + 68, y: this.hex[i].y + 58, occupied: -1, tiles: [], port: -1, });
		this.corners.push({
			x: this.hex[i].x + 35, y: this.hex[i].y + 78, occupied: -1, tiles: [], port: -1, });
	}
	for (var i = 8; i < 89; i+=9) {
		this.corners.push({
			x: this.hex[i].x + 35, y: this.hex[i].y + 78, occupied: -1, tiles: [], port: -1, });
	}
	this.corners2 = [];
	for (var i = 0; i < this.corners.length; i++) {
		var dupe = false;
		for (var j = 0; j < this.corners2.length; j++) {
			if (isWithin(this.corners[i].x, this.corners2[j].x, 10) && isWithin(this.corners[i].y, this.corners2[j].y, 10)) {
				dupe = true;
			}
		}
		if (!dupe) { 
			this.corners2.push({
				x: this.corners[i].x, y: this.corners[i].y, occupied: -1, tiles: [], port: -1, });
		}
	}
	this.corners = this.corners2;
	
	this.roads = [];
	for (var i = 0; i < this.corners.length; i++) {
		for (var j = 0; j < this.corners.length; j++) {
			if (i != j) {
				if (isWithin(this.corners[i].x, this.corners[j].x, 36) && isWithin(this.corners[i].y, this.corners[j].y, 45)) {
					this.roads.push([i, j, -1, false]);
				}
			}
		}
	}
	var roads2 = [];
	for (var i = 0; i < this.roads.length; i++) {
		var dupe = false;
		for (var j = 0; j < roads2.length; j++) {
			if ((this.roads[i][0] == roads2[j][0] && this.roads[i][1] == roads2[j][1]) || (this.roads[i][1] == roads2[j][0] && this.roads[i][0] == roads2[j][1])) {
				dupe = true;
			}
		}
		if (!dupe) {
			roads2.push([this.roads[i][0], this.roads[i][1], -1, false]);
		}
	}
	this.roads = roads2;
	for (var i = 0; i < this.roads.length; i++) {
		if (this.corners[this.roads[i][0]].x > this.corners[this.roads[i][1]].x) { 
			var left = this.roads[i][1]; var right = this.roads[i][0];
			this.roads[i] = [left, right, -1, false];
		}
		else if (this.corners[this.roads[i][0]].x == this.corners[this.roads[i][1]].x && this.corners[this.roads[i][0]].y > this.corners[this.roads[i][1]].y) {
			var left = this.roads[i][1]; var right = this.roads[i][0];
			this.roads[i] = [left, right, -1, false];
		}
	}
	this.ports = [];
	this.setResources();
	this.d_cards = getDCards();
}

_server.prototype.setResources = function() {
	for (var i = 0; i < this.hex.length; i++) {
		var x1 = this.hex[i].x - 5;
		var x2 = this.hex[i].x + 80;
		var y1 = this.hex[i].y - 5;
		var y2 = this.hex[i].y + 90;
		for (var j = 0; j < this.corners.length; j++) {
			if (this.corners[j].x > x1 && this.corners[j].x < x2 && this.corners[j].y > y1 && this.corners[j].y < y2) {
				this.corners[j].tiles.push(this.hex[i]);
				this.hex[i].corners.push(j);
			}
		}
	}
}

_server.prototype.send = function(TEXT) {
	for (var i = 0; i < this.players.length; i++) { this.players[i].send(TEXT); }
}

_server.prototype.sendBoard = function(WHO) {
	var image = [];
	for (var j = 0; j < this.hex.length; j++) {
		image.push(this.hex[j].image);
	}
	this.players[WHO].send("board*" + image + "\n");
	var portHex = []; var portA = []; var portB = []; var portID = [];
	for (var j = 0; j < this.ports.length; j++) {
		portHex.push(this.ports[j][0]); portA.push(this.ports[j][1]);
		portB.push(this.ports[j][2]); portID.push(this.ports[j][3]);
	}
	this.players[WHO].send("ports*" + portHex + "*" + portA + "*" + portB + "*" + portID + "\n");
}

_server.prototype.checkDuplicatePlayer = function(WHO) {
	var duplicate = false;
	for (var i = 0; i < this.players.length; i++) {
		if (WHO == this.players[i].name) { duplicate = true; }
	}
	
	return duplicate;
}

_server.prototype.getDie = function() {
	var rollset = [];
	while (rollset.length < 25) { rollset.push(getRandom(0,5)); }
	var die = rollset[getRandom(0,24)]
	
	return die;
}	

_server.prototype.distributeResources = function(ROLL, WHO) {
	var r = [];
	if (!this.started) {
		for (var i = 0; i < this.corners[ROLL].tiles.length; i++) {
			if (this.corners[ROLL].tiles[i].image < 5) { 
				r.push(this.corners[ROLL].tiles[i].image); 
				this.players[WHO].resources.push(this.corners[ROLL].tiles[i].image);
			}
		}
		this.players[WHO].resources.sort(compareNumbers);
		this.send("resources*" + WHO + "*" + this.players[WHO].resources + "\n" + "newResource*" + WHO + "*" + r + "\n");
	}
	else {
		var newResources = [];
		for (var i = 0; i < this.players.length; i++) {
			var r = [];
			for (var a = 0; a < this.players[i].settlements.length; a++) {
				for (var t = 0; t < this.corners[this.players[i].settlements[a]].tiles.length; t++) {
					if (this.corners[this.players[i].settlements[a]].tiles[t].number == ROLL && !this.corners[this.players[i].settlements[a]].tiles[t].robber) {
						if (this.corners[this.players[i].settlements[a]].tiles[t].image < 5) { 
							r.push(this.corners[this.players[i].settlements[a]].tiles[t].image); 
							this.players[i].resources.push(this.corners[this.players[i].settlements[a]].tiles[t].image); 
						}
					}
				}
			}
			for (var a = 0; a < this.players[i].cities.length; a++) {
				for (var t = 0; t < this.corners[this.players[i].cities[a]].tiles.length; t++) {
					if (this.corners[this.players[i].cities[a]].tiles[t].number == ROLL && !this.corners[this.players[i].cities[a]].tiles[t].robber) {
						if (this.corners[this.players[i].cities[a]].tiles[t].image < 5) {
							r.push(this.corners[this.players[i].cities[a]].tiles[t].image);
							r.push(this.corners[this.players[i].cities[a]].tiles[t].image);
							this.players[i].resources.push(this.corners[this.players[i].cities[a]].tiles[t].image);
							this.players[i].resources.push(this.corners[this.players[i].cities[a]].tiles[t].image);
						}
					}
				}
			}
			this.players[i].resources.sort(compareNumbers);
			this.send("resources*" + i + "*" + this.players[i].resources + "\n");
			newResources.push(r);
		}
		this.send("newResource*" + newResources[0] + "*" + newResources[1] + "*" + newResources[2] + "\n");
	}
}

_server.prototype.setNumbers = function() {
	var available = [];
	for (var i = 0; i < this.hex.length; i++) {
		if (this.hex[i].number == -1) { //available hex to be numbered., number param is for future
			if (this.hex[i].image == 7 || this.hex[i].image < 5) {
				available.push(i);
			}
		}
	}
	var numberCount = Math.floor(available.length / 18); //2,3,4,5,6, 8,9,10,11,12
	var numberSupply = [0,0,0,0,0, 0,0,0,0,0];
	for (var i = 0; i < numberSupply.length; i++) {
		numberSupply[i] = numberCount;
		if (i != 0 && i != 9) { numberSupply[i]++; }
		numberSupply[i] *= numberCount;
	}
	var left = available.length % 18;
	var miniSupply = [0,0,0,0,0, 0,0,0,0,0];
	if (left != 0) { //a number less than 18, 1-17
		if (left >= numberSupply.length) {
			for (var i = 0; i < numberSupply.length; i++) { numberSupply[i]++; }
			left -= numberSupply.length;
		}
		if (left > 0) {
			var used = 0;
			while (used < left) {
				var a = getRandom(0, numberSupply.length - 1);
				if (miniSupply[a] == 0) { numberSupply[a]++; miniSupply[a]++; used++; } 
			}
		}
	}
	var used = 0;
	var numbers = [];
	while (used < available.length) {
		var a = getRandom(0, numberSupply.length);
		if (numberSupply[a] > 0) { 
			if (a < 5) { var b = a + 2; numbers.push(b); }
			else { var b = a + 3; numbers.push(b); }
			numberSupply[a]--;
			used++;
		}
	}
	for (var i = 0; i < available.length; i++) { this.hex[available[i]].number = numbers.pop(); }
}

_server.prototype.setHexes = function() {
	var available = [];
	for (var i = 0; i < this.hex.length; i++) {
		if (this.hex[i].image == 7) {
			available.push(i);
		}
	}
	var amount = available.length;
	var tileSupply = [];
	//assume for now that deserts are not initially defined.
	for (var i = 0; i < this.robber.where.length; i++) { tileSupply.push(5); amount--;}
	//balance remaining supply.
	var each = Math.floor(amount / 5);
	var left = amount % 5;
	for (var i = 0; i < each; i++) {
		tileSupply.push(0); tileSupply.push(1); tileSupply.push(2); tileSupply.push(3); tileSupply.push(4); 
	}
	for (var i = 0, j = 0; i < left; i++,j++) { tileSupply.push(j); }
	for (var i = 0, robber = 0; i < available.length; i++) {
		var tile = tileSupply.splice(getRandom(0, tileSupply.length-1),1);
		this.hex[available[i]].image = tile;
		if (tile == 5) { 
			this.robber.where[robber] = available[i];
			this.hex[available[i]].robber = true;
			robber++;
		}
	}
}

_server.prototype.playerAbleToRob = function(WHO) {
	var robable = false;
	if (!this.options.noRobOn2) { robable = true; }
	else {
		for (var i = 0; i < this.players.length; i++) {
			if (this.players[i].points > 2 && WHO != i) { robable = true; }
		}
	}
	return robable;
}

_server.prototype.removeResource = function(WHAT, AMOUNT, WHO) {
	//must be sure to have resource!
	var location = -1;
	for (var i = 0; i < this.players[WHO].resources.length; i++) {
		if (location == -1) {
			if (this.players[WHO].resources[i] == WHAT) {
				location = i;
			}
		}
	}
	if (location == -1) { Abort("Error\n Can not find card location in removeResource\n"+ WHAT+ " -IN: " + this.players[WHO].resources); }
	this.players[WHO].resources.splice(location, AMOUNT);
}

_server.prototype.howManyResource = function (WHAT, WHO) {
	var have = 0; 
	for (var i = 0; i < this.players[WHO].resources.length; i++) {
		if (this.players[WHO].resources[i] == WHAT) { have++; }
	}
	return have;
}

function isWithin(a, b, x) {
	if (Math.abs(a - b) < x) return true;
	else return false;
}

function _client() {
	this.name = "";
	this.id = 0;
	this.port;
	this.settlements = [];
	this.roads = []; 
	this.cities = [];
	this.boats = 0;
	this.resources = [];
	this.points = 0;
	this.d_cards = [];
	this.tableCards = [];
	this.wait = false;
	this.roll = [];
	this.playedRobber = false;
	this.playedD_card = false;
	this.tradeOffer = [];
	this.tradeDemand = [];
	this.tradeTalk = "";
	this.discard = 0;
	this.discarded = [];
	this.havePorts = [];
	this.currentColor;
	this.ping = 0;
	this.latency = 0;
	this.careerPoints = 0;
	this.wins = 0;
	this.losses = 0;
}

_client.prototype.send = function(TEXT) {
	this.port.write(CreateByteArrayFromString(TEXT));
}

function getDCards() {
	var pile = [];
	var cards = [0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,1, 1,2,2,3,3, 4,5,6,7,8]; //cards, not shuffled.
	var pending;
	
	while (pile.length < 25) {
		pending = Math.floor(Math.random() * cards.length);
		pile.push(cards[pending]);
		cards.splice(pending, 1);
	}
	return pile;
}

function getOrder(START) {
	var order = []
	if (START == 0) { order.push(0,1,2,2,1,0); }
	else if (START == 1) { order.push(1,2,0,0,2,1); }
	else { order.push(2,0,1,1,0,2); }
	return order;
}

function compareNumbers(a, b) {
  if(a > b) { return 1; }
  if(a < b) { return -1; }
  return 0;
}

function getRandom(min, max) {  
  return Math.floor(Math.random() * (max - min + 1)) + min;  
} 

function DegreesToRadians(degrees) {
  return (degrees * Math.PI / 180.0);
}
